; Original Barrel Vise macro by Daniels @ 1280x1024 resolution - 02/01/2010

; This modified version by Cegaiel for 1024x768 resolution
; Modifed as follows:
; Set amount of barrels you want to make via dialogue
; GUI status message while the script runs
; Stops stoking towards end and lets heat finish it up (saving a couple/few wood)
; You need 100 boards, 2 copper straps and about 60 wood (averages 51-56 wood per barrel, but 60 to be safe) per barrel in inventory.
; Takes about 5 mins per barrel

; Date: 10/02/2010



; The following should stop runaway macros
; Ctrl+P (Pause) and Ctrl+R (Reload script)
^p::Pause
^r::Reload

; Barrel Vise - Pin window in upper right of screen.
; Coordinates are for Guilded or Public barrel vice (in other words, there should be two lines in the label):
; 1st line is "This is a Barrel Vise", 2nd line: "Usable by ???"
; If the barrel vise you are using is yours and not guilded, then you will temporarily need to change it to Public


; Pin when barrel vise it is COMPLETELY empty.

; Ctrl+Alt+W to start the macro
^!w::


	WinGetActiveStats, win_Title, Xmax, Ymax, win_Xpos, win_Ypos

	;======================================================================
	;Check to see if we are in the correct resolution, or else exit script.
	;You may remove this entire routine, if you wish.

	if !(Xmax = 1032) && !(Ymax = 746)
	{
	Msgbox, You are not in 1024x768 resolution`n`nExiting...
	EXIT
	}
	;======================================================================




IfWinExist eGenesis Client
{


;;;;;;;;;;;;;;;;;;;;;; COORD VARIABLES ;;;;;;;;;;;;;;;;;;;;;;
; Beginning of bar (Edge of black line): x=70 ,  End of bar: x=191
	

	winX := 80 		; Top of window X/Y Coords, used to select and update the pinned window
	winY := 55
	makeX := 60 		;Make button and also Take X/Y Coords
	makeY := 95
	takeAllX := makeX + 35 
	takeAllY := makeY + 10
	stokeX := 168		; Stoke Button X/Y Coords
	stokeY := 236

	; This is towards the end of progress bar, when it detects blue, at this coord, it starts looking for the Take... option
	; It also stops stoking, should be enough heat to finish it the last 2 ticks, save a couple wood.
	; Make this about 2 coords (X coord) from the end of the bar
	;Also prevents a stoke after the barrel completes, which results in a popup.
	ProgressX := 189 
	ProgressY := 219


	; Max Flame wanted (DANGER), do not have 2 wood in Fuel passed this point.  May need to adjust.
	; Set about 24 coords (X coord) from the end of bar
	barMaxFlameX := 167 


	bar1WoodX := 72 	; Coord for determining if at least 1 wood is in Fuel (+2 coords from left bar (black area/edge bar)
	bar2WoodX := 78 	; Coord for determining if at least 2 wood is in Fuel (+8 coords from left bar (black area/edge bar)
	
	fuelBarY := 170  	; Y Coord for Fuel bar
	flameBarY := 187 	; Y Coord for Flame bar


	
;;;;;;;;;;;;;;;;;;;;;; MAIN PROGRAM ;;;;;;;;;;;;;;;;;;;;;;


InputBox, Qty, Barrels, How many barrels do you want to make?
counter = 0
totalwood = 0
avgwood = N/A

SetDefaultMouseSpeed, 0
;SetMouseDelay, -1


	if (Qty < 0)
	{
	Msgbox, You did not enter a Qty!`n`nExiting...`n`nCtrl+Alt+W to try again
	EXIT
	}


	Gui, +AlwaysOnTop +ToolWindow
	Gui, Font, norm
	Gui, Add, Text, vMineCycleText, Preparing to start ... Standby ...`n`n`n`n`n`n`n`n`n`n`n`n`n
	Gui, Show
	GuiControl, Text, MineCycleText, Preparing to start ... Standby ...`n`n`n`n`n`n`n`n`n`n`n`n`n


	Delay = 5
	;Just a small delay before starting in case we are using the Right Pinup version at same time.
	Loop, %Delay%
	{
	GuiControl, Text, MineCycleText, Script begins in %Delay%s
	Delay --
	Sleep 1000
	}

	GuiControl, Text, MineCycleText, Focusing eGenesis client



	Loop, %Qty% ; number of barrels to make
	{
		WinActivate, eGenesis Client
		wood = 0
		cooldown = 0
		seconds = 0
		minutes = 0
		seconds_eta = 35
		minutes_eta = 5 


		;Check that there isn't a barrel (Take... in menu present) from a previous run. If so, Take the barrel first.
		MouseClickCoords(winX, winY)
		Sleep 100
		ImageSearch, OutputX, OutputY, 12, 87, 112, 103, *50 Take.PNG
		Sleep 100

		;If Take... menu appears (ErrorLevel 0) then Unload Barrel
		if (ErrorLevel = 0)
		{
GuiControl, Text, MineCycleText, Making Barrel: %counter% of %qty%`n`nCurrent Fuel: -`nCurrent Flame: -`n`nLast: Unloading Barrel

		;Unload Barrel
		MouseClickCoords(winX, winY)
		sleep 500
		MouseClickCoords(makeX, makeY)
		sleep 500
		MouseClickCoords(takeAllX, takeAllY)
		sleep 500
		MouseClickCoords(winX, winY)
		sleep 500
		}

			ActionStatus := "Making Barrel"


GuiControl, Text, MineCycleText, Making Barrel: %counter% of %qty%`n`nCurrent Fuel: -`nCurrent Flame: -`n`nLast: Making Barrel

		; Click "Make a barrel"
		MouseClickCoords(winX, winY)
		Sleep 500
		MouseClickCoords(makeX, makeY)
		Sleep 500


		;Search for a popup immediately after clicking "Make Barrel" in case we dont have the ingredients in inventory
		Gosub, SearchPopUpBox


	#Persistent 
	SetTimer, Timer, 1000



	counter ++

		
		Loop ; Maintain Heat
		{		

			WinActivate, eGenesis Client


;Search for popup during Maintain Heat cycle, which would mean your barrel was incinerated.
;Or it didn't properly take the barrel from last run and its trying to stoke it.


			Gosub, SearchPopUpBox



			curFuel1 := FindBlue(bar1WoodX, fuelBarY)
			curFuel2 := FindBlue(bar2WoodX, fuelBarY)
			curFlame := FindBlue(barMaxFlameX, flameBarY)
			curProgress := FindBlue(ProgressX, ProgressY)

			if (curFuel2 = 0)
			{
			FuelStatus := 2			
			}
			else if (curFuel1 = 0)
			{
			FuelStatus := 1
			}
			else
			{
			FuelStatus := 0
			}

			if (curProgress = 0)
			cooldown := 1



			;Optional stuff, just bells and whistles, below lines (x coords) dont need to be correct for macro to run correctly.
			;This simply shows a progress % on GUI interface as macro runs

			10percentProgress := FindBlue(82, ProgressY)
			20percentProgress := FindBlue(94, ProgressY)
			30percentProgress := FindBlue(106, ProgressY)
			40percentProgress := FindBlue(118, ProgressY)
			50percentProgress := FindBlue(130, ProgressY)
			60percentProgress := FindBlue(142, ProgressY)
			70percentProgress := FindBlue(154, ProgressY)
			80percentProgress := FindBlue(166, ProgressY)
			90percentProgress := FindBlue(178, ProgressY)
			95percentProgress := FindBlue(184, ProgressY)


			if (95percentProgress = 0)
			{
			pdone := 95
			}
			else if (90percentprogress = 0)
			{
			pdone := 90
			}
			else if (80percentprogress = 0)
			{
			pdone := 80
			}
			else if (70percentprogress = 0)
			{
			pdone := 70
			}
			else if (60percentprogress = 0)
			{
			pdone := 60
			}
			else if (50percentprogress = 0)
			{
			pdone := 50
			}
			else if (40percentprogress = 0)
			{
			pdone := 40
			}
			else if (30percentprogress = 0)
			{
			pdone := 30
			}
			else if (20percentprogress = 0)
			{
			pdone := 20
			}
			else if (10percentprogress = 0)
			{
			pdone := 10
			}
			else
			{
			pdone := 0
			}

			;End optional bells and whistles (Show Progress: ## percent in GUI status bar) 




GuiControl, Text, MineCycleText, Making Barrel: %counter% of %qty%`n`nCurrent Fuel: %FuelStatus% Wood`nCurrent Flame: %FlameStatus%`n`nLast: %ActionStatus%`n`nWood Used: %wood%`n`nProgress: %pdone% percent`n`nElapsed: %minutes%m %seconds%s`nETA:      %minutes_eta%m %seconds_eta%s

			if (cooldown = 1) ;Stop Stoking, should be enough heat to finish
			{
			ActionStatus := "Waiting for completion"
			FlameStatus := "Cooling down"
			pdone := 99
			}
			else if (curFlame > 0)
			{					
			FlameStatus := "OK"

				if (curFuel1 > 0) ; Add 2 wood
				{
					MouseClickCoords(stokeX, stokeY)							
					MouseClickCoords(stokeX, stokeY)
					ActionStatus := "Stoke (2 Wood)"
					wood ++
					wood ++
					totalwood ++
					totalwood ++
				}
				else if (curFuel2 > 0) ; Add 1 wood
				{
					MouseClickCoords(stokeX, stokeY)
					ActionStatus := "Stoke (1 Wood)"
					wood ++
					totalwood ++
				}				


			} else {
			FlameStatus := "DANGER"
			ActionStatus := "No Stoke (0 Wood)"
			}


GuiControl, Text, MineCycleText, Making Barrel: %counter% of %qty%`n`nCurrent Fuel: %FuelStatus% Wood`nCurrent Flame: %FlameStatus%`n`nLast: %ActionStatus%`n`nWood Used: %wood%`n`nProgress: %pdone% percent`n`nElapsed: %minutes%m %seconds%s`nETA:      %minutes_eta%m %seconds_eta%s


				if (cooldown = 1)
				; Close to being done, start looking for "Take..." to appear
				; As soon as it appears, break the loop and move onto the "Unload barrel" routine, below
				{				
				MouseClickCoords(winX, winY)
				Sleep 100
				ImageSearch, OutputX, OutputY, 12, 87, 56, 103, *50 Take.PNG
				Sleep 100

				if (ErrorLevel = 0)
				break
				}




		
		}  ;End Maintain Heat Loop



;This only occurs when after the loop (Maintain Heat) is broken

GuiControl, Text, MineCycleText, Making Barrel: %counter% of %qty%`n`nCurrent Fuel:Fuel: -`nCurrent Flame: -`n`nLast: Unloading Barrel`n`nWood (This barrel): %wood%

		; Unload barrel
		MouseClickCoords(winX, winY)
		sleep 500
		MouseClickCoords(makeX, makeY)
		sleep 500
		MouseClickCoords(takeAllX, takeAllY)
		sleep 500
		MouseClickCoords(winX, winY)
		sleep 500
	}

avgwood := (totalwood / qty)
avgwood := Round(avgwood)


if (qty > 1)
{
GuiControl, Text, MineCycleText, Made %counter% Barrels`n`nAll Done!`n`nWood Used (Last barrel): %wood%`nWood Used (Total): %totalwood%`nAvg wood per barrel: %avgwood%`n`nElapsed: %minutes%m %seconds%s`n`nCtrl+R to reload/reset script
} else {
GuiControl, Text, MineCycleText,  Made %counter% Barrel`n`nAll Done!`n`nWood Used: %wood%`n`nElapsed: %minutes%m %seconds%s`n`nCtrl+R to reload/reset script
}


}


MouseClickCoords(X, Y)
{

;	MouseMove, X, Y
;	sleep 100
;	MouseClick
;	sleep 100

Click, %X%, %Y%
Sleep 250
}

FindBlue(TX, TY)
{	
	PixelSearch, PX, PY, TX, TY, TX+1, TY+1, 0xFD0606, 55, Fast
	return ErrorLevel
}







		SearchPopUpBox:

		PixelSearch, Px, Py, 529, 481, 529, 481, 0xECDFBD, 15, Fast|RGB

		if ErrorLevel = 0
		{
		SoundPlay *48
		Sleep 1000
		SoundPlay *48
		Sleep 1000
		SoundPlay *48
		Sleep 1000
		SoundPlay *48
		Sleep 1000
		SoundPlay *48
		Sleep 1000
		SoundPlay *48

		MsgBox, Popup box detected, there must be an error somewhere!`n`nReloading/Exiting script...
		RELOAD
		} else {
		return
		}



		ClosePopUpBox:

		PixelSearch, Px, Py, 529, 481, 529, 481, 0xECDFBD, 15, Fast|RGB
		if ErrorLevel = 0
		{
		Click, 529, 481
		Sleep 250
		Click, 529, 481
		Sleep 250
		}
		return


		Timer:
		seconds ++

		if (seconds = 60)
		{
		seconds := 0
		minutes ++
		}
		
		if (seconds_eta = 0) and !(minutes_eta = 0)
		{
		seconds_eta := 60
		minutes_eta --
		}
		
		if (minutes_eta < 0)
		minutes_eta := 0

		seconds_eta --
		return
